//
//  ComAirDemoLogFileHandler.m
//  ComAirRaw
//
//  Created by GeneralPlus_sa1 on 12/7/25.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "LogFileHandler.h"

@interface LogFileHandler ()
{
	NSMutableString     *m_pLogString;
}
@end

@implementation LogFileHandler


//----------------------------------------------------------------
-(id)init
{
    self = [super init];
    if (self) {
        // Custom initialization
		m_pLogString = [[NSMutableString alloc]initWithFormat:@""];
    }
    return self;
}
//-----------------------------------------------------------------
-(bool)	RemoveFile:(NSString*)fileNmae;
{
	NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
	NSString *documentsDir = [paths objectAtIndex:0];
	NSString *filename = [documentsDir stringByAppendingPathComponent:fileNmae];	
	NSURL *fileURL = [[NSURL alloc] initFileURLWithPath: filename];
	
	NSFileManager *manager = [NSFileManager defaultManager];
	NSError *error;
	
	[manager removeItemAtURL:fileURL error:&error];
	
	return true;
}
//-----------------------------------------------------------------
-(bool)		RemoveLogFiles
{
	NSString *RawName = [[NSString alloc]initWithFormat:PCMFILE];  
	[self RemoveFile:RawName];
	
	NSString *LogName = [[NSString alloc]initWithFormat:COMMANDFILE];  
	[self RemoveFile:LogName];
	
	return true;
}
//-----------------------------------------------------------------
-(bool)	DoWriteFile:(NSData *)BinaryData
{
	NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
	NSString *documentsDir = [paths objectAtIndex:0];
    NSString *LogName = [[NSString alloc]initWithFormat:PCMFILE];
	NSString *filename = [documentsDir stringByAppendingPathComponent:LogName];	
	
	NSFileHandle *FileHandle = [NSFileHandle fileHandleForUpdatingAtPath:filename];
	NSData *WriteData = [NSData dataWithBytes:abyRecBuff length:m_i32RecSize];
	
	if(FileHandle ==NULL)
	{
		[WriteData writeToFile:filename atomically:YES];
		
	}
	else
	{
		[FileHandle seekToEndOfFile];
		[FileHandle writeData:WriteData];
		[FileHandle closeFile];
	}
	
	WriteData = nil;
	
	memset(abyRecBuff,0x00,FILEWRITEBUFSIZE);

	return true;
}
//-----------------------------------------------------------------
-(bool)	LogCommand:(NSString*)Message
{
	//get the documents directory:
	NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
	NSString *documentsDir = [paths objectAtIndex:0];
    NSString *LogName = [[NSString alloc]initWithFormat:COMMANDFILE];
	NSString *filename = [documentsDir stringByAppendingPathComponent:LogName];	
	NSFileHandle *FileHandle = [NSFileHandle fileHandleForWritingAtPath:filename]; 
	
	if(FileHandle==NULL)
	{
		//save content to the documents directory
		[Message writeToFile:filename 
				  atomically:NO 
					encoding:NSStringEncodingConversionAllowLossy 
					   error:nil];
	}
	else
	{
		[FileHandle truncateFileAtOffset:[FileHandle seekToEndOfFile]]; 
		[FileHandle writeData:[Message dataUsingEncoding:NSUTF8StringEncoding]];
	}
	
	
	return true;
}
//-----------------------------------------------------------------
-(NSString*) GetLogString
{
	//get the documents directory:
	NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
	NSString *documentsDir = [paths objectAtIndex:0];
    NSString *LogName = [[NSString alloc]initWithFormat:COMMANDFILE];
	NSString *filename = [documentsDir stringByAppendingPathComponent:LogName];
	NSFileHandle *FileHandle = [NSFileHandle fileHandleForReadingAtPath:filename];
	
	if(FileHandle==NULL)
	{
		return @"";
	}
	else
	{
		NSData *pLogData =  [FileHandle readDataToEndOfFile];
		NSString *myString = [[NSString alloc] initWithData:pLogData encoding:NSUTF8StringEncoding];
		[m_pLogString setString:myString];

		return m_pLogString;
	}
}
//-----------------------------------------------------------------
-(bool)	WriteFile:(unsigned char*)buffer WithSize:(int)i32len
{	
	
	int i32total = m_i32WriteLen + i32len ;
	
	if(i32total >= FILEWRITEBUFSIZE) 
	{
		int i32left = FILEWRITEBUFSIZE - m_i32WriteLen;
		memcpy(&abyWriteBuff[m_i32WriteLen],buffer,i32left);
		memcpy(abyRecBuff,abyWriteBuff,FILEWRITEBUFSIZE);
		m_i32RecSize = FILEWRITEBUFSIZE;
		
		[NSThread detachNewThreadSelector:@selector(DoWriteFile:)  toTarget:self withObject:nil];
		
		memset(abyWriteBuff,0x00,FILEWRITEBUFSIZE);
		m_i32WriteLen = 0;
		i32left = i32total - FILEWRITEBUFSIZE;
		if(i32left>0)
		{
			memcpy(abyWriteBuff,&buffer[i32len - i32left],i32left);
			m_i32WriteLen += i32left;
		}
		
	}
	else 
	{
		memcpy(&abyWriteBuff[m_i32WriteLen],buffer,i32len);
		m_i32WriteLen += i32len;
	}
	
	
	return true;
	
}
//-----------------------------------------------------------------

@end
